/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.ducks.GeckolibGeoArmorAccessor;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

@Pseudo
@Mixin(value={GeoRenderer.class}, remap=false)
public interface GeckolibGeoRendererMixin<T extends GeoAnimatable> {
    @Shadow
    public void renderRecursively(PoseStack var1, GeoAnimatable var2, GeoBone var3, RenderType var4, MultiBufferSource var5, VertexConsumer var6, boolean var7, float var8, int var9, int var10, int var11);

    @Shadow
    public void updateAnimatedTextureFrame(T var1);

    @Overwrite
    default public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        this.updateAnimatedTextureFrame(animatable);
        CallbackInfo callbackInfo = new CallbackInfo("figura$renderPivots", true);
        this.figura$renderPivots(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color, callbackInfo);
        if (callbackInfo.isCancelled()) {
            return;
        }
        for (GeoBone group : model.topLevelBones()) {
            this.renderRecursively(poseStack, (GeoAnimatable)animatable, group, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        }
    }

    @Unique
    default public void figura$renderPivots(PoseStack poseStack, GeoAnimatable geoAnimatable, BakedGeoModel bakedGeoModel, RenderType renderType, MultiBufferSource multiBufferSource, VertexConsumer vertexConsumer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color, CallbackInfo ci) {
        boolean allFailed = true;
        if (this instanceof GeoArmorRenderer && ((GeckolibGeoArmorAccessor)((Object)this)).figura$getAvatar() != null) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)this;
            if (armorRenderer.getCurrentSlot() == null) {
                return;
            }
            Avatar avatar = ((GeckolibGeoArmorAccessor)armorRenderer).figura$getAvatar();
            if (avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) < 1) {
                return;
            }
            GeoModel model = armorRenderer.getGeoModel();
            switch (armorRenderer.getCurrentSlot()) {
                case HEAD: {
                    allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.HelmetPivot, geoAnimatable, armorRenderer.getHeadBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    if (!allFailed) break;
                    this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getHeadBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    break;
                }
                case CHEST: {
                    allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.ChestplatePivot, geoAnimatable, armorRenderer.getBodyBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    if (allFailed) {
                        this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getBodyBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    }
                    if (allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.LeftShoulderPivot, geoAnimatable, armorRenderer.getLeftArmBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color)) {
                        this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getLeftArmBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    }
                    if (!(allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.RightShoulderPivot, geoAnimatable, armorRenderer.getRightArmBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color))) break;
                    this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getRightArmBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    break;
                }
                case LEGS: {
                    allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.LeftLeggingPivot, geoAnimatable, armorRenderer.getLeftLegBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    if (allFailed) {
                        this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getLeftLegBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    }
                    this.figura$renderPivot(armorRenderer, avatar, ParentType.RightLeggingPivot, geoAnimatable, armorRenderer.getRightLegBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    if (!allFailed) break;
                    this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getRightLegBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    break;
                }
                case FEET: {
                    allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.LeftBootPivot, geoAnimatable, armorRenderer.getLeftBootBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    if (allFailed) {
                        this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getLeftBootBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    }
                    if (!(allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.RightBootPivot, geoAnimatable, armorRenderer.getRightBootBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color))) break;
                    this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getRightBootBone(model), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
                    break;
                }
            }
            ci.cancel();
        }
    }

    @Unique
    default public boolean figura$renderPivot(GeoArmorRenderer armorRenderer, Avatar avatar, ParentType parentType, GeoAnimatable geoAnimatable, GeoBone geoBone, RenderType renderType, MultiBufferSource multiBufferSource, VertexConsumer vertexConsumer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        if (geoBone == null) {
            return true;
        }
        int armorEditPermission = avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT);
        VanillaPart part = RenderUtils.pivotToPart(avatar, parentType);
        if (armorEditPermission == 1 && part != null && !part.checkVisible()) {
            return false;
        }
        if (armorEditPermission != 1) {
            return true;
        }
        return !avatar.pivotPartRender(parentType, stack -> {
            geoBone.setRotX(0.0f);
            geoBone.setRotY(0.0f);
            geoBone.setRotZ(0.0f);
            stack.pushPose();
            this.figura$prepareArmorRender((PoseStack)stack);
            this.figura$transformBasedOnType(geoBone, (PoseStack)stack, parentType);
            ((GeckolibGeoArmorAccessor)armorRenderer).figura$setEntityRenderTranslations(stack.last().pose());
            stack.pushPose();
            BakedGeoModel model = armorRenderer.getGeoModel().getBakedModel(armorRenderer.getGeoModel().getModelResource(geoAnimatable));
            armorRenderer.scaleModelForBaby(stack, (Item)geoAnimatable, partialTick, isReRender);
            armorRenderer.scaleModelForRender(((GeckolibGeoArmorAccessor)armorRenderer).figura$getScaleWidth(), ((GeckolibGeoArmorAccessor)armorRenderer).figura$getScaleHeight(), stack, geoAnimatable, model, isReRender, partialTick, packedLight, packedOverlay);
            stack.translate(0.0f, 1.5f, 0.0f);
            stack.scale(-1.0f, -1.0f, 1.0f);
            ((GeckolibGeoArmorAccessor)armorRenderer).figura$setModelRenderTranslations(stack.last().pose());
            this.renderRecursively((PoseStack)stack, geoAnimatable, geoBone, renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, color);
            stack.popPose();
            stack.popPose();
        });
    }

    @Unique
    default public void figura$transformBasedOnType(GeoBone bone, PoseStack poseStack, ParentType parentType) {
        if (parentType == ParentType.LeftShoulderPivot) {
            bone.setPosY(0.0f);
            bone.setPosZ(0.0f);
            bone.setPosX(0.0f);
            poseStack.translate(-0.375f, 0.0f, 0.0f);
        } else if (parentType == ParentType.RightShoulderPivot) {
            bone.setPosY(0.0f);
            bone.setPosZ(0.0f);
            bone.setPosX(0.0f);
            poseStack.translate(0.375f, 0.0f, 0.0f);
        } else if (parentType == ParentType.LeggingsPivot) {
            poseStack.translate(0.0f, -0.75f, 0.0f);
        } else if (parentType == ParentType.LeftLeggingPivot) {
            poseStack.translate(-0.125f, -0.75f, 0.0f);
        } else if (parentType == ParentType.RightLeggingPivot) {
            poseStack.translate(0.125f, -0.75f, 0.0f);
        } else if (parentType == ParentType.LeftBootPivot) {
            poseStack.translate(-0.125f, -1.5f, 0.0f);
        } else if (parentType == ParentType.RightBootPivot) {
            poseStack.translate(0.125f, -1.5f, 0.0f);
        }
    }

    @Unique
    default public void figura$prepareArmorRender(PoseStack stack) {
        stack.scale(16.0f, 16.0f, 16.0f);
        stack.mulPose(Axis.XP.rotationDegrees(180.0f));
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
    }
}

